﻿using Inet.Viewer.Data;
using System;
using System.Collections.Generic;
using System.Drawing.Printing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Inet.Viewer.Samples
{
    /// <summary>
    /// An example how to use the printing API without the viewer (headless).
    /// Optionally, a print dialog (WinForms) can be shown to let the user choose a printer.
    /// </summary>
    public class PrintHeadlessExample
    {
        const bool ShowPrintDialog = true;

        /// <summary>
        /// Main method of the example
        /// </summary>
        /// <param name="args"></param>
        [STAThread]
        public static void Main(string[] args)
        {
            URLRenderData renderData = new URLRenderData("http://localhost:9000/?report=startpage/start.rpt");
            PrinterSettings settings = new PrinterSettings();
            
            // Default printer settings can be set here, e.g:
            //  settings.PrinterName = "Fax";
            //  settings.FromPage = 1;
            //  settings.ToPage = 2;

            PrintProgress printProgress = new PrintProgress(renderData, settings, OnError);
            printProgress.UpdatePageSettings();

            if (ShowPrintDialog)
            {
                PrintDialog printDialog = new PrintDialog();
                printDialog.PrinterSettings = settings;
                printDialog.AllowPrintToFile = true;
                printDialog.UseEXDialog = true;

                if (printDialog.ShowDialog() != DialogResult.OK)
                {
                    return;
                }
            }

            printProgress.StartProgress();
            printProgress.WaitUntilFinished();

            Console.WriteLine("PrintProgress terminated with status '" + printProgress.Status+"'");
        }

        /// <summary>
        /// Method used as delegate to obtain exceptions when an error occurs during printing.
        /// </summary>
        /// <param name="e"></param>
        private static void OnError(Exception e)
        {
            Console.WriteLine("PRINTING FAILED:\n" + e);
        }
    }
}
